/**

VIDEO ANALYSIS PREPROCESSING  - MODULES
author: Pavel Zak, izakpa@fit.vutbr.cz

Each module does specific image operation. The abstract factory design enables extension with new modules that perform additional tasks.
In that case, you need to:
1) inherit the basic module class and implement process() method.
2) add new IF statement in the module factory method getPreproc_Module().

*/

#ifndef __preprocessingModules_h__
#define __preprocessingModules_h__

#include <string>
#include <vector>
#include <iostream>
#include <map>

#include "cv.h"
#include "highgui.h"

using namespace std;

/**
* Basic class of preprocessing modules.
*/
class Preproc_module{
protected:
	string typ;
	//int typint;
	vector<Preproc_module *> next;
	//map<string, string> params;
	IplImage * result;
	string qid;
	bool inited;
	int64 timestamp;
public:
	~Preproc_module();
	Preproc_module(string type, map<string, string> parameters, string queue);

	virtual int process(IplImage * image, int64 frameNo, string sourceID = "") = 0;

	void add_next(Preproc_module * module);
	bool isOK();
	string getQid();
	IplImage * getResult();
	int64 getTimeStamp();
};
//////////////////////////////
/**
* Module for resizing of images.
*/
class Preproc_resize: public Preproc_module{
	int width, height;
	public: 
		Preproc_resize(string type, map<string, string> parameters, string queue);
		int process(IplImage * image, int64 frameNo, string sourceID = "");
};

/**
* Module for cropping of images.
*/
class Preproc_crop: public Preproc_module{
	public: 
		Preproc_crop(string type, map<string, string> parameters, string queue);
		int process(IplImage * image, int64 frameNo, string sourceID = "");
	protected:
		int width, height, top, left;
};

/**
* Module for skipping of images throu the timeline.
*/
class Preproc_nskip: public Preproc_module{
	public: 
		Preproc_nskip(string type, map<string, string> parameters, string queue);
		int process(IplImage * image, int64 frameNo, string sourceID = "");
	protected:
		int64 lastNo;
		bool firstcall;
		int frameskip;
};

/**
* Module for converting the color spaces of the images.
*/
class Preproc_convert: public Preproc_module{
	string from, to;
	int code, depth, channels;
	public: 
		Preproc_convert(string type, map<string, string> parameters, string queue);
		int process(IplImage * image, int64 frameNo, string sourceID = "");
};

/**
* Module for choosing of the image sources.
*/
class Preproc_source: public Preproc_module{
	string source;
	public: 
		Preproc_source(string type, map<string, string> parameters, string queue);
		int process(IplImage * image, int64 frameNo, string sourceID = "");
};
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/**
* Creates specific module based on the string identifier.
*/
class Preproc_ModuleFactory{
public:
	Preproc_module * getPreproc_Module(string type, map<string, string> parameters, string queue);
};

#endif